from qelimutils import *

def fm_conj_smt(conj, to_elim):
    ineqs = set()
    for lit in conj:
        if lit.is_not():
            ineqs.add(to_linear(lit.arg(0), True))
        else:
            ineqs.add(to_linear(lit, False))

    with Solver() as smt:
        for x in to_elim:
            c_p = {c for c in ineqs if coeff(c, x) > 0}
            c_n = {c for c in ineqs if coeff(c, x) < 0}
            ineqs = ineqs - (c_p | c_n)
            for l1 in c_p:
                for l2 in c_n:
                    l = combine(l1, l2, x)
                    t = to_term(l)
                    smt.push()
                    smt.add_assertion(Not(t))
                    res = smt.solve()
                    smt.pop()
                    if res:
                        ineqs.add(l)
                        smt.add_assertion(t)

    return And(*[to_term(l) for l in ineqs])


def fm_smt(formula, to_elim):
    atoms = list(get_atoms(formula))
    with Solver() as smt:
        res = FALSE()
        smt.add_assertion(formula)
        #i = 0
        while smt.solve():
            m = smt.get_model()
            conj = []
            for a in atoms:
                if smt.get_py_value(a):
                    conj.append(a)
                else:
                    conj.append(Not(a))
            #start = time.time()
            conj_e = fm_conj_smt(conj, to_elim)
            #end = time.time()
            res = Or(res, conj_e)
            smt.add_assertion(Not(conj_e))
            #print(';; disjunct %d, time: %.3f' % (i+1, (end - start)))
            #i += 1
        return res.simplify()
