from qelimutils import *


def fm_conj_simple(conj, to_elim):
    ineqs = set()
    for lit in conj:
        if lit.is_not():
            ineqs.add(to_linear(lit.arg(0), True))
        else:
            ineqs.add(to_linear(lit, False))

    for x in to_elim:
        c_p = {c for c in ineqs if coeff(c, x) > 0}
        c_n = {c for c in ineqs if coeff(c, x) < 0}
        ineqs = ineqs - (c_p | c_n)
        for l1 in c_p:
            for l2 in c_n:
                l = combine(l1, l2, x)
                ineqs.add(l)

    return And(*[to_term(l) for l in ineqs])


def fm_simple(formula, to_elim):
    #start = time.time()
    f = dnf(formula)
    #end = time.time()
    #print(';; dnf computation time: %.3f' % (end - start))
    res = FALSE()
    for i, conj in enumerate(disjunctive_partition(f)):
        #start = time.time()
        conj_e = fm_conj_simple(conjunctive_partition(conj), to_elim)
        #end = time.time()
        #print(';; disjunct %d, time: %.3f' % (i+1, (end - start)))
        res = Or(res, conj_e)
    return res.simplify()


