from pysmt.shortcuts import *
import argparse
import random

def getopts():
    p = argparse.ArgumentParser()
    p.add_argument('--vars', type=int, required=True)
    p.add_argument('--constrs', type=int, required=True)
    p.add_argument('--clauses', type=int, required=True)
    p.add_argument('--lits', type=int, required=True)
    p.add_argument('--seed', type=int, default=None)
    p.add_argument('--qvars', type=int, required=True)
    p.add_argument('--constrvars', type=int, required=True)
    return p.parse_args()


def main():
    opts = getopts()
    random.seed(opts.seed)
    xs = [FreshSymbol(types.REAL) for i in range(opts.vars)]
    constrs = []
    for i in range(opts.constrs):
        rhs = Real(0)
        for x in random.sample(xs, opts.constrvars):
            n = random.randrange(1, 100) * random.choice([-1, 1])
            rhs = Plus(Times(Real(n), x))
        constrs.append(LE(Real(random.randrange(100) * random.choice([-1, 1])),
                          rhs))
    res = []
    for i in range(opts.clauses):
        c = []
        for l in random.sample(constrs, opts.lits):
            if random.choice([True, False]):
                l = Not(l)
            c.append(l)
        res.append(Or(*c))

    res = Exists(random.sample(xs, opts.qvars), And(*res))

    write_smtlib(res, '/dev/stdout')

main()

        
