from __future__ import print_function
import elim_simple
import elim_fm
import elim_vts
import argparse
import time
from pysmt.shortcuts import *


def elim_native(formula, to_elim):
    return qelim(Exists(to_elim, formula))


def main():
    p = argparse.ArgumentParser()
    p.add_argument('--algo', required=True,
                   choices=('simple', 'fm', 'vts', 'native'))
    p.add_argument('--print', action='store_true', default=False)
    p.add_argument('--check', action='store_true', default=False)
    opts = p.parse_args()
    formula = read_smtlib('/dev/stdin')
    to_elim = []
    while formula.is_exists():
        to_elim += formula.quantifier_vars()
        formula = formula.arg(0)
    alg = {
        'simple': elim_simple.fm_simple,
        'fm': elim_fm.fm_smt,
        'vts': elim_vts.vts,
        'native': elim_native,
        }
    start = time.time()
    print(';; computing with %s algo' % opts.algo)
    res = alg[opts.algo](formula, to_elim)
    end = time.time()
    print(';; time: %.3f' % (end - start))
    if opts.check:
        print(';; cross-checking with native qelim')
        start = time.time()
        res2 = qelim(Exists(to_elim, formula))
        ok = is_valid(Iff(res, res2))
        print(';; result: %s' % ok)
        end = time.time()
        print(';; time: %.3f' % (end - start))
    if opts.print:
        write_smtlib(res, '/dev/stdout')


if __name__ == '__main__':
    main()
