from __future__ import print_function
from model import *
import bmc


class ItpUnroller(bmc.Unroller):
    def __init__(self, model):
        super(ItpUnroller, self).__init__(model)
        self.time2var = {}

    def get_time_var(self, x, k):
        ret = super(ItpUnroller, self).get_time_var(x, k)
        self.time2var[ret] = x
        return ret

    def untime(self, formula):
        for x in formula.get_free_variables():
            if x not in self.time2var:
                raise Exception("unknown variable")
        return formula.substitute(self.time2var)

# end of class ItpUnroller


class Itp(object):
    def __init__(self, model):
        self.model = model
        self.unroller = ItpUnroller(model)

    def check(self, max_k):
        bad = Not(self.model.invarprops[0])
        if is_sat(And(self.unroller.at_time(self.model.init, 0),
                      self.unroller.at_time(bad, 0))):
            return False
        k = 1
        while True:
            if max_k is not None and k == max_k:
                break
            print('checking step %d' % k)
            res = self.itp_check(k)
            if res is not None:
                return res
            k += 1
        return None

    def itp_check(self, k):
        reach = self.model.init
        bad = Not(self.model.invarprops[0])
        badk = Or(*[self.unroller.at_time(bad, i) for i in xrange(1, k+1)])
        suffix = And(badk,
                     *[self.unroller.at_time(self.model.trans, i)
                       for i in xrange(1, k)])
        trans0 = self.unroller.at_time(self.model.trans, 0)

        i = 0
        while True:
            print('  itp step %d' % i)
            prefix = And(self.unroller.at_time(reach, 0), trans0)
            itp = binary_interpolant(prefix, suffix)
            if itp is None:
                if i == 0:
                    return False
                else:
                    return None
            else:
                r = self.unroller.untime(itp)
                if is_valid(Implies(r, reach)):
                    return True
                else:
                    i += 1
                    reach = Or(reach, r)
                    
# end of class Itp


if __name__ == '__main__':
    import sys
    model = Model.read(sys.stdin)
    itp = Itp(model)
    res = itp.check(None)
    if res == False:
        print('unsafe')
    elif res == True:
        print('safe')
    else:
        print('unknown')
