import os, sys
from pysmt.shortcuts import *
from pysmt.smtlib.parser import SmtLibParser


class Model(object):
    def __init__(self, statevars, init, trans, invarprops):
        self.statevars = statevars
        self.init = init
        self.trans = trans
        self.invarprops = invarprops

    @staticmethod
    def read(fileobj):
        parser = SmtLibParser()
        script = parser.get_script(fileobj)
        if not script.annotations:
            raise Exception("no annotation found")
        ann = script.annotations
        init = reduce(
            lambda a, b: And(a, b), ann.all_annotated_formulae("init", "true"),
            TRUE())
        trans = reduce(
            lambda a, b: And(a, b), ann.all_annotated_formulae("trans", "true"),
            TRUE())
        invarprops = sorted(ann.all_annotated_formulae("invar-property"),
                            key=lambda f: int(ann[f]["invar-property"].pop()))
        statevars = []
        for v in sorted(ann.all_annotated_formulae("next"), key=str):
            n = ann[v]["next"].pop()
            vn = Symbol(n, v.get_type())
            statevars.append((v, vn))

        return Model(statevars, init, trans, invarprops)

# end of class Model
