from __future__ import print_function
from model import *

class ReachableStates(object):
    def __init__(self, model):
        self.model = model
        self.cex = None
        self.reach = model.init

    def check(self, max_k):
        bad = Not(self.model.invarprops[0])
        k = 0
        qvars = sorted(self.model.trans.get_free_variables() - \
                       set(v[1] for v in self.model.statevars),
                       key=str)
        while True:
            if max_k is not None and k == max_k:
                break
            print('computing reachable states after %d steps' % k)
            if is_sat(And(self.reach, bad)):
                return False
            frontier = qelim(Exists(qvars, And(self.reach, self.model.trans)))
            frontier = frontier.substitute(
                dict((b, a) for (a, b) in self.model.statevars))
            if is_valid(Implies(frontier, self.reach)):
                return True
            self.reach = Or(self.reach, frontier)
            k += 1
        return None

# end of class ReachableStates


if __name__ == '__main__':
    import sys
    model = Model.read(sys.stdin)
    reach = ReachableStates(model)
    res = reach.check(None)
    if res == False:
        print('unsafe')
    elif res == True:
        ## print('reachable states:')
        ## write_smtlib(reach.reach.simplify(), '/dev/stdout')
        print('safe')
    else:
        print('unknown')
