//root -l histo2.cpp
//creating and filling histograms with and without weights
#include <iostream>
#include <TApplication.h>
#include <TCanvas.h>
#include <TH1F.h>
#include <TRandom.h>
using namespace std;
void histo2()
{

  // create canvas and divide
  TCanvas *c = new TCanvas("myCanvas","My Canvas");
  c->Divide(2,2);


  // create histograms
  TH1F *h1 = new TH1F("my_hist1","Gauss",50,-500,500);
  TH1F *h2 = new TH1F("my_hist2","Poisson",50,0,100);
  TH1F *h3 = new TH1F("my_hist3","Weighted Gauss",50,-500,500);
  TH1F *h4 = new TH1F("my_hist4","Weighted Poisson",50,0,100);

  // set styles
  h1->SetFillColor(4);
  h2->SetFillColor(6);
  h3->SetFillColor(5);
  h4->SetFillColor(7);

  // create random number and fill histogram
  TRandom *ran = new TRandom(450);
  for(int ii=0;ii<10000;ii++){
    h1->Fill(ran->Gaus(0,100));
    h2->Fill(ran->Poisson(40));
    h3->Fill(ran->Gaus(0,100),2);// weighted by 2
    h4->Fill(ran->Poisson(40),2);// weighted by 2
  }
  // draw histograms
  c->cd(1);
  h1->Draw();
  c->cd(2);
  h2->Draw();
  c->cd(3);
  h3->Draw();
  c->cd(4);
  h4->Draw();

  // setting the axis title for h1
  h1->GetXaxis()->SetTitle("Gauss Values");
  h1->GetYaxis()->SetTitle("Counts");

//  c->SaveAs("histo2.png");
//  delete ran;
//  delete c;

}

