//root -l histo5.cpp
//Stacking histograms using THStack
#include <iostream>
#include <TApplication.h>
#include <TCanvas.h>
#include <TH1F.h>
#include <TRandom.h>
#include <THStack.h>

using namespace std;
void histo5()
{

    // create canvas
    TCanvas *c = new TCanvas("myCanvas","My Canvas");
    // create histograms
    TH1F *h1 = new TH1F("my_hist1","Gauss",50,-500,500);
    TH1F *h2 = new TH1F("my_hist2","Gauss",50,-500,500);
    // styles
    h1->SetFillColor(4);
    h2->SetFillColor(6);

    // fill histograms with random numbers
    TRandom *ran = new TRandom(450);
    for(int ii=0;ii<10000;ii++){
        h1->Fill(ran->Gaus(0,50));
        h2->Fill(ran->Gaus(0,100));
    }

  THStack *hs = new THStack("Stack","Stack of my histograms");
  hs->Add(h1);
  hs->Add(h2);
  c->cd();
  hs->Draw();


//    delete ran;
//    delete c;

}
