//root -l histo8.cpp
//Fitting
#include <iostream>
#include <TApplication.h>
#include <TCanvas.h>
#include <TH1F.h>
#include <TRandom.h>
#include <TF1.h>
#include <TStyle.h>
using namespace std;
void histo8()
{

    // create canvas
    TCanvas *c = new TCanvas("myCanvas","My Canvas");
    // create histograms
    TH1F *h1 = new TH1F("my_hist1","Gauss",50,-500,500);
    // styles
    h1->SetFillColor(4);
    // fill histograms with random numbers
    TRandom *ran = new TRandom(450);
    for(int ii=0;ii<10000;ii++){
        h1->Fill(ran->Gaus(0,50));
    }
    //draw  first
    h1->Draw();
    // change style to show fit parameters
    gStyle->SetOptFit(1011);
    // Fitting using pre-defined function
    //h1->Fit("gaus");

    // Fitting using user-defined functions
    TF1 *func = new TF1("myGauss","[0]*exp(-0.5*((x-[1])/[2])**2)",-180,180);
    // parameter names
    func->SetParNames("Factor","Mean","Sigma");
    //Set Parameters:
    func->SetParameter(0,1);
    func->SetParameter(1,0);
    func->SetParameter(2,50);
    h1->Fit(func,"R");// use option "R" to restrict to a certain region for fitting

    // fixing parameters: FixParamter, SetParamterLimits


   //To get the paramter values programmatically:
    cout<<"Parameter Factor: "<<func->GetParameter(0)<<endl;
    cout<<"Parameter Mean: "<<func->GetParameter(1)<<endl;
    cout<<"Parameter Sigma: "<<func->GetParameter(2)<<endl;
    // update

    delete ran;


}




