//******************************************************
//Simultaneous Fit of deltaM distribution for D0->Pi0Pi0
//******************************************************
#ifndef __CINT__
#include "RooGlobalFunc.h"
#endif
#include "RooRealVar.h"
#include "RooDataSet.h"
#include "RooGaussian.h"
#include "RooConstVar.h"
#include "RooChebychev.h"
#include "RooAddPdf.h"
#include "RooSimultaneous.h"
#include "RooCategory.h"
#include "TCanvas.h"
#include "TAxis.h"
#include "RooPlot.h"

using namespace RooFit;
void sim_fit(void)
{
  RooRealVar A("A","A",0.14,0.16,"GeV/c^{2}");
  //LOAD DATA FILE
  TChain* chain=new TChain("ntup");
 
  chain->Add("./Example_1.root");

  Int_t nevt=(int)chain->GetEntries();
  cout<<"nevt\t"<<nevt <<endl;
  
    Float_t o_A , o_B ,o_C, o_D;
   chain->SetBranchAddress("A",& o_A);
   chain->SetBranchAddress("B",& o_B);
   chain->SetBranchAddress("C",& o_C);
   chain->SetBranchAddress("D",& o_D);

  RooDataSet*data_p=new RooDataSet("data_p","data_p",RooArgSet(A));
  RooDataSet*data_n=new RooDataSet("data_n","data_n",RooArgSet(A));

  Double_t s_p(0);
  Double_t s_n(0);

  Double_t nevt_ac_p(0);
  Double_t nevt_ac_n(0);
  for(int i=0;i<nevt;i++) 
    {
      chain->GetEntry(i);
	  if(o_A>0.14 && o_A<0.16)

	   
	       if(o_C==+1)
		   {
		  nevt_ac_p++;
		  A.setVal(o_A);
		  data_p->add(RooArgSet(A));
		if(o_D==1)
			{
		      s_p++;
		      }
		    
		    }
	      else
		{
		  nevt_ac_n++;
		  A.setVal(o_A);
		  data_n->add(RooArgSet(A));
		  
	       if(o_D==1)
		{
		      s_n++;
		   }
		    
		}
	    }
   

  cout<<"nevt_after cut_p"<<nevt_ac_p<<endl;
  cout<<"nevt_after cut_n"<<nevt_ac_n<<endl;
  
  cout<<endl;
  cout<<"s_p"<<s_p<<endl;
  cout<<"s_n"<<s_n<<endl;
  
  //cout<<endl;
  Double_t b_p=nevt_ac_p-s_p;
  Double_t b_n=nevt_ac_n-s_n;
  cout<<"b_p "<<b_p<<endl;
  cout<<"b_n "<<b_n<<endl;
  Double_t abkg=(b_p-b_n)/(b_p+b_n);
  Double_t nue=sqrt(b_p+b_n);

  Double_t asig=(s_p-s_n)/(s_p+s_n);
  Double_t anue=sqrt(s_p+s_n);

  cout<<endl;
  cout<<"nBkg "<<(b_p+b_n)<<"+-"<<nue<<endl;
  cout<<"nSig "<<(s_p+s_n)<<"+-"<<anue<<endl;
  cout<<endl;
  Double_t abkge=abkg*sqrt(pow((nue/(b_p-b_n)),2.0)+pow((nue/(b_p+b_n)),2.0));
  Double_t asige=asig*sqrt(pow((anue/(s_p-s_n)),2.0)+pow((anue/(s_p+s_n)),2.0));
  cout<<endl;
  cout<<"Abkg "<<abkg<<"+-"<<abkge<<endl;
  cout<<"Asig "<<asig<<"+-"<<asige<<endl;
  cout<<endl;
  //DEFINE PDF
  //___________________________
  //CHARGE=+1

  //SIGNAL  
 // ---  Bifurcated Gaussian p.d.f. ---
   RooRealVar mean("#mu", "mean",0.1458,0.144,0.147); 
  
   RooRealVar sigma("#sigma", " sigma",0.0005,0.0001,0.002);
   RooGaussian gauss1("gauss1","gauss1",A,mean,sigma);

   
 
    RooRealVar sigma2("#sigma2", " sigma2",0.0004989);
    RooGaussian gauss2("gauss2","gauss2",A,mean,sigma2);

    RooRealVar b2b("b2b", " Area2/Area1",0.537);
  

   RooRealVar sigmal("#sigma_{l}", " sigmal", 0.001108);
   RooRealVar sigmar("#sigma_{r}", " sigmar",0.001429);
   RooBifurGauss Bif_gauss1("Bif_gauss1", "Bif_gauss1", A, mean, sigmal, sigmar);
   RooRealVar a2a("a2a", " Area2/Area1",0.1425); 
   RooAddPdf signal_p("signal_p", " 1st GAuss + 2nd Gauss", RooArgList(Bif_gauss1, gauss2,gauss1),RooArgList(a2a,b2b));


    RooRealVar Th("Th", "Threshold", 0.13957018);
    RooRealVar a("a", "a", 0.0008,-10,2);
    RooRealVar b("b", "b",-0.0125, -100,1000);

   RooGenericPdf bkg_p("bkg_p", "pow((A-0.13957018),a)*exp(-1*b*(A-0.13957018))",RooArgSet(A,Th,a,b));


   
/////////////////////////////
  RooRealVar Araw("Araw","Araw",0,-1,1);
  RooRealVar N_t("N_t","N_t",15000,0,2000000);//80000
  RooFormulaVar N_n("N_n","(0.5)*(1-Araw)*N_t",RooArgList(Araw,N_t));
  RooFormulaVar N_p("N_p","(0.5)*(1+Araw)*N_t",RooArgList(Araw,N_t));
  /////////////////////////////
  RooRealVar Abkg("Abkg","Apbkg",0,-1,1);
  RooRealVar N_tb("N_tb","N_tb",6500,0,1000000);//250000
  RooFormulaVar N_nb("N_nb","(0.5)*(1-Abkg)*N_tb",RooArgList(Abkg,N_tb));
  RooFormulaVar N_pb("N_pb","(0.5)*(1+Abkg)*N_tb",RooArgList(Abkg,N_tb));

  
  RooAddPdf model_p("model_p", "Model",RooArgList(signal_p,bkg_p), RooArgList(N_p,N_pb));

  
  /////////////////////////////
  //___________________________
  //CHARGE=-1

 RooGaussian gauss1n("gauss1n","gauss1n",A,mean,sigma);
 RooGaussian gauss2n("gauss2n","gauss2n",A,mean,sigma2);
RooBifurGauss Bif_gauss1n("Bif_gauss1n", "Bif_gauss1n", A, mean, sigmal, sigmar);
RooAddPdf signal_n("signal_n", " 1st GAuss + 2nd Gauss", RooArgList(Bif_gauss1n, gauss2n,gauss1n),RooArgList(a2a,b2b));
   
    RooGenericPdf bkg_n("bkg_n", "pow((A-0.13957018),a)*exp(-1*b*(A-0.13957018))",RooArgSet(A,Th,a,b));


  
 

  
  RooAddPdf model_n("model_n", "Model",RooArgList(signal_n,bkg_n), RooArgList(N_n,N_nb));
  
  //CREATE INDEX CATEGORY AND JOIN  SAMPLEs
  //___________________________
  RooCategory sample("sample","sample");
  sample.defineType("pos");
  sample.defineType("neg");
  RooDataSet combData("combData","combData",A,Index(sample),Import("pos",*data_p),Import("neg",*data_n));
  
  RooSimultaneous simPdf("simPdf","simPdf",sample);
  simPdf.addPdf(model_p,"pos");
  simPdf.addPdf(model_n,"neg");
  //___________________________
  
  simPdf.fitTo(combData,Extended(true),Minos(true),Save());
  
  //PLOTING
  RooPlot *xframe_1 =A.frame(Bins(100),Title("D^{0}"),MarkerColor(kBlack),MarkerSize(0.6), XErrorSize(0.2));
  combData.plotOn(xframe_1,Cut("sample==sample::pos"));
  simPdf.plotOn(xframe_1,Slice(sample,"pos"),ProjWData(sample,combData),LineWidth(2));
  simPdf.plotOn(xframe_1,Slice(sample,"pos"),Components("bkg_p"),ProjWData(sample,combData),LineStyle(kDashed),LineWidth(3));
 // simPdf.plotOn(xframe_1,Slice(sample,"pos"),Components("peak_p"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kCyan),LineWidth(3));
  simPdf.plotOn(xframe_1,Slice(sample,"pos"),Components("signal_p"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kRed),LineWidth(3));
 // simPdf.plotOn(xframe_1,Slice(sample,"pos"),Components("Bif_gauss1"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kMagenta),LineWidth(3));
  //model_p.paramOn(xframe_1,data_p);
  RooPlot *xframe_2 = A.frame(Bins(100),Title("#bar{D}^{0}"),MarkerColor(kBlack),MarkerSize(0.6), XErrorSize(0.2));
  combData.plotOn(xframe_2,Cut("sample==sample::neg"));
  simPdf.plotOn(xframe_2,Slice(sample,"neg"),ProjWData(sample,combData),LineWidth(2));
  simPdf.plotOn(xframe_2,Slice(sample,"neg"),Components("bkg_n"),ProjWData(sample,combData),LineStyle(kDashed),LineWidth(3));
 // simPdf.plotOn(xframe_2,Slice(sample,"neg"),Components("peak_n"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kCyan),LineWidth(3));
  simPdf.plotOn(xframe_2,Slice(sample,"neg"),Components("signal_n"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kRed),LineWidth(3));
  //simPdf.plotOn(xframe_2,Slice(sample,"neg"),Components("sig_pdf1_n"),ProjWData(sample,combData),LineStyle(kDashed),LineColor(kMagenta),LineWidth(3)); 
model_p.paramOn(xframe_2,data_n);
  TCanvas* c3 = new TCanvas("c3","c3",2000,2000) ;
c3->Divide(2,1);
   
  Int_t k=558;
  ostringstream convert;
  convert<<k;
  std::string title;
  title=convert.str();

  TPaveText *pt1 = new TPaveText(.05,.1,.95,.8);
  pt1->AddText(title.c_str());  
  //c3->Divide(2) ;
  c3->cd(1) ; gPad->SetLeftMargin(0.15) ; 
  xframe_1->GetYaxis()->SetTitleOffset(1.4) ; 
  xframe_1->GetXaxis()->SetLabelSize(0.03);
  xframe_1->GetXaxis()->SetTitleSize(0.04);
  xframe_1->GetXaxis()->SetLabelOffset(0.01);
  xframe_1->GetXaxis()->CenterTitle();
  xframe_1->GetYaxis()->SetLabelSize(0.03);
  xframe_1->GetYaxis()->SetTitleSize(0.04);
  xframe_1->GetYaxis()->SetTitleOffset(1.3);
  xframe_1->GetYaxis()->SetLabelOffset(0.01);
  xframe_1->GetYaxis()->CenterTitle();
 
  xframe_1->GetYaxis()->SetNdivisions(505);
  
  xframe_1->Draw("");
 
  c3->cd(2) ; gPad->SetLeftMargin(0.15) ; xframe_2->GetYaxis()->SetTitleOffset(1.4) ;
  xframe_2->GetXaxis()->SetLabelSize(0.03);
  xframe_2->GetXaxis()->SetTitleSize(0.04);
  xframe_2->GetXaxis()->SetLabelOffset(0.01);
  xframe_2->GetXaxis()->CenterTitle();
  xframe_2->GetYaxis()->SetLabelSize(0.03);
  xframe_2->GetYaxis()->SetTitleSize(0.04);
  xframe_2->GetYaxis()->SetTitleOffset(1.3);
  xframe_2->GetYaxis()->SetLabelOffset(0.01);
  xframe_2->GetYaxis()->CenterTitle();
  xframe_2->GetYaxis()->SetNdivisions(505);
  xframe_2->Draw();

  


  c3->Update();
  cout<<"chi^2-1 "<<xframe_1->chiSquare()<<endl; 
  cout<<"chi^2-2 "<<xframe_2->chiSquare()<<endl; 
   
 
  

  RooArgSet* params = simPdf->getVariables() ;
  RooRealVar* e = (RooRealVar*) params->find("N_tb");
  RooRealVar* f = (RooRealVar*) params->find("N_t");
  RooRealVar* z = (RooRealVar*) params->find("Abkg");
  RooRealVar* d = (RooRealVar*) params->find("Araw");

  cout<<"______________________________________________________________"<<endl;
  cout<<"nBkg\t"<<(b_p+b_n)<<"+-"<<nue<<"\t\t\t"<<a.getVal()<<"+-"<<a.getError()<<endl;
  cout<<"nSig\t"<<(s_p+s_n)<<"+-"<<anue<<"\t\t\t"<<b.getVal()<<"+-"<<b.getError()<<endl;
  cout<<"Abkg\t"<<abkg<<"+-"<<abkge<<"\t\t"<<z.getVal()<<"+-"<<z.getError()<<endl;
  cout<<"Asig\t"<<asig<<"+-"<<asige<<"\t"<<d.getVal()<<"+-"<<d.getError()<<endl;
  cout<<"______________________________________________________________"<<endl;

//c->SaveAs("acp_kspi0.png");
}
