
void toymc(void){

// --- Observable ---
RooRealVar x("x","variable x", 0, 10) ;
// --- Build Gaussian1 PDF ---
RooRealVar mean1("mean1","mean of Gaussian1 PDF", 4, 0, 10) ;
RooRealVar width1("width1","sigma of Gaussian1 PDF", 1, 0, 2) ;
RooGaussian gauss1("gauss1","gaussian1 PDF",x, mean1, width1) ;

// --- Generate a toyMC sample of 10000 events from double Gaussian PDF ---
RooDataSet *data = gauss1.generate(x, 10000) ;
// --- Perform chi^2 fit of double Gaussian PDF to toy data ---
gauss1.fitTo(*data) ;

RooPlot* xframe = x.frame() ;
data->plotOn(xframe) ;
gauss1.plotOn(xframe) ;
//chi^2/DoF between data and double Gaussian PDF
Double_t chiSquare = xframe -> chiSquare();
std::cout << "chisq =  " << chiSquare << std::endl;

TCanvas *c = new TCanvas("c"); //creating a canvas
c->Divide(1,2); //divide the canvas
c->cd(1); //first pad
xframe->Draw();

c->cd(2);

    // Construct a histogram with the pulls of the data w.r.t the curve (double Gaussian PDF)
    RooHist* hpull = xframe->pullHist() ;
    RooPlot* frame3 = x.frame() ;
    frame3->addPlotable(hpull,"P") ;
frame3->Draw();

}
