#ifndef __CINT__
#include "RooGlobalFunc.h"
#endif
#include "RooRealVar.h"
#include "RooDataSet.h"
#include "RooGaussian.h"
#include "RooConstVar.h"
#include "RooChebychev.h"
#include "RooAddPdf.h"
#include "RooSimultaneous.h"
#include "RooCategory.h"
#include "TCanvas.h"
#include "TAxis.h"
#include "RooPlot.h"
#include "RooGenericPdf.h"
#include "RooAbsPdf.h"
 #include "RooMCStudy.h"
 #include "TH2.h"
 #include "RooFitResult.h"
 #include "TStyle.h"
 #include "TDirectory.h"

using namespace RooFit;
void twodfit_00_total(void)
{
  TCanvas* c1 = new TCanvas("c1","c1",1200,800) ;


  RooRealVar B("B","B",1.845,1.885,"GeV/c^{2}");
  RooRealVar A("A","A",0.14,0.16,"GeV");
  RooDataSet* data=new RooDataSet("data","data",RooArgSet(A,B));//********** // add the variable use for the modelling


  //LOAD DATA FILE
  TChain* chain=new TChain("ntup");

 // chain->Add("./final_00.root");
  chain->Add("./Example_1.root");
  Int_t nevt=(int)chain->GetEntries();
 // cout<<"nevt\t"<<10000 <<endl;


	 Float_t o_A , o_B ,o_C, o_D;
   chain->SetBranchAddress("A",& o_A);
   chain->SetBranchAddress("B",& o_B);
   chain->SetBranchAddress("C",& o_C);
   chain->SetBranchAddress("D",& o_D);
   
  Int_t nevt_ac_p(0);
  Int_t nevt_ac_n(0);
  //for(int i=0;i<nevt;i++) 
for(int i=0;i<5000;i++) 
    {
      chain->GetEntry(i);
		  B.setVal(o_B);
		  A.setVal(o_A);

//Selection Criteria
if(o_B> 1.845 && o_B < 1.885) {
 if(o_A < 0.14 || o_A > 0.16) continue;
if ( o_D == 1) { 
data->add(RooArgSet(A,B));
}
}
}
//Only fitting is needed. Data is ready

//Fittings
  RooRealVar N_s("N_s","N_s",100,0,100000);
  RooRealVar N_b("N_b","N_b",100,0,100000);



//PDF   
//For B

//Gaussian
   RooRealVar mean1("#mu1", "mean",1.86,1.85,1.88);
   RooRealVar sigma("#sigma","sigma", 0.005, 0., 0.03);
   RooGaussian sig_1("sig_1","sig_1", B, mean1, sigma); //model the respective distributions
    RooRealVar ratio("#sigma/#sigma1","ratio",  0.1,0,7);
 
   RooFormulaVar sigma_sigma1("ratio1", "@0*@1", RooArgSet(sigma, ratio));
   RooGaussian sig_2("sig_2","sig_2", B, mean1, sigma_sigma1);
    RooRealVar b2b("b2a", " Area2/Area1",0.3212,0,1 );

   RooAddPdf sig1("sig1", " 1st GAuss + 2nd Gauss", RooArgList(sig_1,sig_2 ),  RooArgList(b2b));

   RooRealVar c0("c0", "Slope of Polynomial",  -10, 10);
   RooChebychev bkg1("chebpol","Chebshev Polynomial ", B, RooArgList(c0));
 


//For A



 
   RooRealVar mean("#mu", "mean",0.1458,0.144,0.147); 
  
   RooRealVar sigmadm("#sigma_{dm}", " sigma",0.0005,0.0001,0.002);
 
   RooGaussian gauss1("gauss1","gauss1",A,mean,sigmadm);

   
 
    RooRealVar sigma2("#sigma2", " sigma2",0.0004989);
    
   
    
    RooGaussian gauss2("gauss2","gauss2",A,mean,sigma2);

   RooRealVar sigmal1("#sigma_{l1}", " sigmal1", 0.001,0.000,0.0075);
   RooRealVar sigmar1("#sigma_{r1}", " sigmar1", 0.001,0.000,0.0075);
   RooBifurGauss Bif_gauss2("Bif_gauss2", "Bif_gauss2", A, mean, sigmal1, sigmar1);

    RooRealVar b2b1("b2b1", " Area2/Area1",0.537);
  

   RooRealVar sigmal("#sigma_{l}", " sigmal", 0.001108);
   RooRealVar sigmar("#sigma_{r}", " sigmar",0.001429);

   RooBifurGauss Bif_gauss1("Bif_gauss1", "Bif_gauss1", A, mean, sigmal, sigmar);
   RooRealVar a2a1("a2a1", " Area2/Area1",0.1425); 
   RooAddPdf sig2("sig2", " 1st GAuss + 2nd Gauss", RooArgList(Bif_gauss1, gauss2,gauss1),RooArgList(a2a1,b2b1));


   // RooRealVar Th("Th", "Threshold", 0.13957018);
    RooRealVar a("a", "a", 0.0008,-10,2);
    RooRealVar b("b", "b",-0.0125, -100,1000);

   RooGenericPdf bkg2("bkg2", "pow((A-0.13957018),a)*exp(-1*b*(A-0.13957018))",RooArgSet(A,a,b));

 
  RooProdPdf sig("sig","sig",RooArgSet(sig1,sig2));
  RooProdPdf bkg("bkg","bkg",RooArgSet(bkg1,bkg2));

  RooAddPdf model("model", "Model",RooArgList(sig,bkg), RooArgList(N_s,N_b)); //adding two or more models


  //FITTING
   RooFitResult* fitRes = model.fitTo(*data);//,"em"); // fit to data

  //PLOTING 
  c1->Divide(2,1);
  c1->cd(1);
  RooPlot *xframe = data->plotOn(B.frame(80)); //visualize the fit

  model.plotOn(xframe);
  double chi1_ndf = xframe->chiSquare(); //ndf
   model.plotOn(xframe, Components(RooArgList(bkg1)),LineStyle(kDashed),LineColor(kBlue));
   model.plotOn(xframe, Components(RooArgList(sig1)),LineStyle(kDashed),LineColor(kGreen));
    model.plotOn(xframe, Components(RooArgList(sig_1)),LineStyle(kDashed),LineColor(kCyan));
    model.plotOn(xframe, Components(RooArgList(sig_2)),LineStyle(kDashed),LineColor(kRed));
  TGaxis::SetMaxDigits(3);
 
  xframe->SetTitle(); 
  xframe->Draw();


  c1->cd(2);
  RooPlot *yframe = data->plotOn(A.frame(80));


  model.plotOn(yframe);
  double chi2_ndf = yframe->chiSquare(); //ndf
  model.plotOn(yframe, Components(RooArgList(bkg2)),LineStyle(kDashed),LineColor(kBlue));
  model.plotOn(yframe, Components(RooArgList(Bif_gauss1)),LineStyle(kDashed),LineColor(kRed));
  model.plotOn(yframe, Components(RooArgList(gauss1)),LineStyle(kDashed),LineColor(kGreen));
  TGaxis::SetMaxDigits(3);
 model.paramOn(yframe,data);
  yframe->SetTitle();


  cout << "chi2_ndf = " << chi2_ndf << " chis1_ndf "<<chi1_ndf<< endl;  
  yframe->Draw();
 

//c1->SaveAs("two2dfit_00_total.png");

}//end of simfit



